
var wkWebview_SearchResultCount = 0;
var wkLastObject;

/*!
 @method     wkWebview_HighlightAllOccurencesOfStringForElement
 @abstract   // helper function, recursively searches in elements and their child nodes
 @discussion // helper function, recursively searches in elements and their child nodes

 element    - HTML elements
 keyword    - string to search
 */

function wkWebview_HighlightAllOccurencesOfStringForElement(element,keyword) {
    if (element) {
        if (element.nodeType == 3) {        // Text node

            var count = 0;
            var elementTmp = element;
            while (true) {
                var value = elementTmp.nodeValue;  // Search for keyword in text node
                var idx = value.toLowerCase().indexOf(keyword);

                if (idx < 0) break;

                count++;
                elementTmp = document.createTextNode(value.substr(idx+keyword.length));
            }

            wkWebview_SearchResultCount += count;

            var index = wkWebview_SearchResultCount;
            while (true) {
                var value = element.nodeValue;  // Search for keyword in text node
                var idx = value.toLowerCase().indexOf(keyword);

                if (idx < 0) break;             // not found, abort

                //we create a SPAN element for every parts of matched keywords
                var span = document.createElement("span");
                var text = document.createTextNode(value.substr(idx,keyword.length));
                span.appendChild(text);

                span.setAttribute("class","wkWebviewHighlight");
                span.style.backgroundColor="white";
                span.style.color="black";
                span.style.position = "relative";
                span.style.zIndex = "1000";
                index--;
                span.setAttribute("id", "SEARCH WORD"+(index));
                //span.setAttribute("id", "SEARCH WORD"+wkWebview_SearchResultCount);

                //element.parentNode.setAttribute("id", "SEARCH WORD"+wkWebview_SearchResultCount);

                //wkWebview_SearchResultCount++;    // update the counter

                text = document.createTextNode(value.substr(idx+keyword.length));
                element.deleteData(idx, value.length - idx);

                var next = element.nextSibling;
                //alert(element.parentNode);
                element.parentNode.insertBefore(span, next);
                element.parentNode.insertBefore(text, next);
                element = text;
            }


        } else if (element.nodeType == 1) { // Element node
            if (element.style.display != "none" && element.nodeName.toLowerCase() != 'select' &&element.nodeName.toLowerCase() != 'style' && element.nodeName.toLowerCase() != 'script') {
                for (var i=element.childNodes.length-1; i>=0; i--) {
                    wkWebview_HighlightAllOccurencesOfStringForElement(element.childNodes[i],keyword);
                }
            }
        }
    }
}

// the main entry point to start the search
function wkWebview_HighlightAllOccurencesOfString(keyword) {
    wkWebview_RemoveAllHighlights();
    
    showOverlay();
    wkWebview_HighlightAllOccurencesOfStringForElement(document.body, keyword.toLowerCase());
}
function hideOverlay(){
    var overlay = document.getElementById("wkWebviewOverlay");
    if (overlay) {
        document.body.removeChild(overlay);
    }
    
}
function showOverlay(){
    var overlay = document.createElement("div");
    overlay.setAttribute("id","wkWebviewOverlay");
    overlay.style.backgroundColor="#000";
    overlay.style.opacity="0.3";
    overlay.style.position = "fixed";
    overlay.style.width = "100%";
    overlay.style.height = "100%";
    overlay.style.display = "block";
    overlay.style.top = "0px";
    overlay.style.left = "0px";
    overlay.style.zIndex = "900";
    overlay.style.pointerEvents = "none";
    document.body.appendChild(overlay);
}

// helper function, recursively removes the highlights in elements and their childs
function wkWebview_RemoveAllHighlightsForElement(element) {
    if (element) {
        if (element.nodeType == 1) {
            if (element.getAttribute("class") == "wkWebviewHighlight") {
                var text = element.removeChild(element.firstChild);
                element.parentNode.insertBefore(text,element);
                element.parentNode.removeChild(element);
                return true;
            } else {
                var normalize = false;
                for (var i=element.childNodes.length-1; i>=0; i--) {
                    if (wkWebview_RemoveAllHighlightsForElement(element.childNodes[i])) {
                        normalize = true;
                    }
                }
                if (normalize) {
                    element.normalize();
                }
            }
        }
    }
    return false;
}

function wkWebview_getLink(x, y)
{
    var item = document.elementFromPoint(x, y);
    if(item.tagName == 'A')
    {
        return item.href;
    }
    var parent = item.parentNode;
    while(true)
    {
        if(parent.tagName == 'A')
        {
            return parent.href;
        }
        parent = parent.parentNode;
    }
}

// the main entry point to remove the highlights
function wkWebview_RemoveAllHighlights() {
    wkWebview_SearchResultCount = 0;
    hideOverlay();
    wkWebview_RemoveAllHighlightsForElement(document.body);
}

function wkWebview_ScrollTo(idx) {
    if (wkLastObject){
        wkLastObject.style.backgroundColor = "white";
    }
    var scrollTo = document.getElementById("SEARCH WORD" + idx);
    if (scrollTo){
        scrollTo.scrollIntoView({behavior: "smooth", block: "center", inline: "nearest"});
        scrollTo.style.backgroundColor = "yellow";
        wkLastObject = scrollTo;
    }
}
